/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.DynamicModifier;
import slimeknights.tconstruct.library.modifiers.util.StaticModifier;

public class ModifierDeferredRegister {
    private final String modId;
    private final Map<ModifierId, Supplier<? extends Modifier>> entries = new LinkedHashMap<ModifierId, Supplier<? extends Modifier>>();
    private final Map<ModifierId, Class<?>> expected = new LinkedHashMap();
    private boolean seenRegisterEvent = false;

    public void register() {
        ModifierManager.ModifierRegistrationEvent.EVENT.register(this::handleEvent);
    }

    public <T extends Modifier> StaticModifier<T> register(String name, Supplier<? extends T> supplier) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after ModifierRegistrationEvent has been fired.");
        }
        ModifierId id = new ModifierId(this.modId, name);
        if (this.expected.containsKey((Object)id)) {
            throw new IllegalArgumentException("Already registered as an dynamic modifier " + String.valueOf((Object)id));
        }
        Supplier<? extends T> original = this.entries.put(id, supplier);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate static registration " + String.valueOf((Object)id));
        }
        return new StaticModifier(id);
    }

    public <T extends Modifier> DynamicModifier<T> registerDynamic(String name, Class<T> classFilter) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after ModifierRegistrationEvent has been fired.");
        }
        ModifierId id = new ModifierId(this.modId, name);
        if (this.entries.containsKey((Object)id)) {
            throw new IllegalArgumentException("Already registered as a static modifier " + String.valueOf((Object)id));
        }
        Class<T> original = this.expected.put(id, classFilter);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate dynamic registration " + String.valueOf((Object)id));
        }
        return new DynamicModifier<T>(id, classFilter);
    }

    private void handleEvent(ModifierManager.ModifierRegistrationEvent event) {
        this.seenRegisterEvent = true;
        for (Map.Entry<ModifierId, Supplier<? extends Modifier>> entry : this.entries.entrySet()) {
            event.registerStatic(entry.getKey(), entry.getValue().get());
        }
        for (Map.Entry<ModifierId, Object> entry : this.expected.entrySet()) {
            event.registerExpected(entry.getKey(), (Class)entry.getValue());
        }
    }

    private ModifierDeferredRegister(String modId) {
        this.modId = modId;
    }

    public static ModifierDeferredRegister create(String modId) {
        return new ModifierDeferredRegister(modId);
    }
}

